function [rmse, cds_new] = wrapper_CDS_mispricing3(x0, cds, CDX, discounts_IMM, start_date_num, end_date_num, maturities)
% --------------------------------------------------------------------------------------------------
% For a set of firm-specific parameters, calculate the model implied CDS spreads (between start_date
% and end_date) and return the RMSE pricing error.
% --------------------------------------------------------------------------------------------------
% x0                ... value(s) of ai
% omega2            ... ai*theta_Y / (theta_i_total)
% cds               ... credit default swap structure (see 'all_steps_in_a_row.m')
% CDX               ... credit index structure which this CDX is part of (because need y0 & dynamics of common factor)
% discounts_IMM     ... structure with discount curves (quarterly horizons)
% start_date_num    ... datenum of start date
% end_date_num      ... datenum of end date
% maturities        ... which maturities to include in calculation of RMSE, default: all
% --------------------------------------------------------------------------------------------------
% sample call: wrapper_CDS_mispricing3(0.5, cds, CDX_NA_IG2, discounts_IMM, datenum('03/17/2006'), datenum('03/17/2006'), [1 1 1])
%{
grid = 0:0.01:5;
x0 = [];
for i = 1:length(grid)
    [trash, cds_tmp] = wrapper_CDS_mispricing2(grid(i), cdx_mor.portfolio(1), cdx_mor, discounts_IMM, 732651, 732651, [1 1 1]);
    x0(i) = cds_tmp.x0;
end
plot(x0);
%}
% --------------------------------------------------------------------------------------------------

% Set parameter defaults
if (nargin <= 4)
    start_date_num = cds.dates{1}(1);
    end_date_num = cds.dates{1}(end);
end
if (nargin <= 6)
    maturities = ones(length(cds.T), 1);
end

% Determine date-range used
start_pos = find(cds.dates{1} >= start_date_num, 1, 'first');
end_pos = find(cds.dates{1} <= end_date_num, 1, 'last');
used_range = start_pos:end_pos;
used_dates = cds.dates{1}(used_range);
if isempty(used_range)
    rmse = NaN;
    cds_new = cds;
    return;
end

% If model is fit to only one maturity of CDS prices, then RMSE is zero => skip calculations below
if ((maturities(1)==1) & (sum(maturities)==1))
    rmse = 0;
    cds_new = cds;
    return;
end
    
% Extract some AJD parameters of common factor
ajd_common_factor = CDX.AJD_common_factor;
sigma = ajd_common_factor.sigma;
mu = ajd_common_factor.mu;

% Calculate omega2 & it's used range
cds1 = CDX.portfolio(1);
theta_avg_one_minus_omega2 =  cds1.AJD.theta ./ cds1.ai;
used_range_cdx = find(logical(is_member_sorted_c(cds1.dates{1}, used_dates)));

% Set new parameters (so that omega2 remains unchanged, sigma_i = sqrt(a_i_Q)*sigma_Y, ...)
ai = abs(x0);
cds.ai(used_range,:) = ai;
cds.AJD.mu(used_range,:) = mu(used_range_cdx) .* ai;
cds.AJD.theta(used_range,:) = ai .* theta_avg_one_minus_omega2(used_range_cdx); % theta_total_i is determined implicitly by omega2 and ai
cds.AJD.sigma(used_range,:) = sigma(used_range_cdx) .* sqrt(ai);

% Update instantaneous default intensity for CDS
cds = update_model_x0_v2(cds, discounts_IMM, CDX, start_date_num, end_date_num);

% Update model-implied CDS prices
cds = update_model_price_cds(cds, discounts_IMM, maturities, start_date_num, end_date_num, CDX.liq_prem_cds(used_range_cdx), ...
                             CDX.AJD_common_factor, CDX.y0);

% Calculate RMSE tranche-pricing error
[rmse, cds_new] = RMSE_CDS_mispricing(cds, start_date_num, end_date_num, maturities);
